* chytrid.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Tests of independence - species vs. infection";
data chytrid;
	input species $ infected $ obsfreq;
	datalines;
A  yes	 7
A  no   18
B  yes  12
B  no   38
C  yes  15
C  no   20
D  yes  27
D  no   13
;
run;
* Print data set;
proc print data=chytrid;
run;
* Tests of independence;
proc freq data=chytrid order=data;
	tables infected*species / chisq cellchi2 expected out=percents outpct;
	weight obsfreq;
	* Can compute an exact test if frequencies are low;
	* Not recommended for large data sets;
	exact chisq;
run;
* Print output data file containing percents;
proc print data=percents;
run;
* Generate bar chart showing percentages;
proc gchart data=percents;
	vbar species / sumvar=pct_col subgroup=infected width=10 woutline=3 
	raxis=axis1 maxis=axis2 legend=legend1;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	axis2 label=(height=2) value=(height=2) width=3;
	legend1 label=(height=2) value=(height=2);
run;
quit;
